﻿//////////////////////////////////////////////
// Scheduler.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkTasks
{
	class SchedulerTask ;
	class Thread ;

	struct SchedulerInfo ;
}

/// Includes ---------------------------------

// nkTasks
#include "../Dll/DllDefines.h"

#include "../Threads/ThreadPool.h"

#include "SchedulerTask.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkTasks
{
	class DLL_TASKS_EXPORT Scheduler final
	{			
		public :
		
			// Constructor, destructor
			Scheduler (unsigned int threadCount = 0) noexcept ;
			~Scheduler () ;

			// Getters
			unsigned int getThreadCount () const ;
			Thread* getThread (unsigned int index) const ;

			// Tasks
			void addTask (nkMemory::UniquePtr<SchedulerTask> task) ;
			void resolveTask (nkMemory::UniquePtr<SchedulerTask> task) ;
			void cancelPendingTasks () ;

			// Update tick, to be called in an update loop
			void tick () ;

			// Threads
			void flush () ;
			void resizeForThreadCount (unsigned int threadCount) ;

		private :
		
			// Attributes
			ThreadPool _threadPool ;
			SchedulerInfo* _schedulerInfo ;
	} ;
}